/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

#define M_PI 3.141592654

/**
 * @param fHue: between 0..1
 */
vec3 palette (float fHue)
{
    vec3 vRgb;
    if (fHue < 1.0/3.0)
    {
        float p = fHue*3.0;
        vRgb.r = 1.0 - p;
        vRgb.g = p;
        vRgb.b = 0.0;
    }
    else if (fHue < 2.0/3.0)
    {
        float p = (fHue - 1.0/3.0)*3.0;
        vRgb.r = 0.0;
        vRgb.g = 1.0 - p;
        vRgb.b = p;
    }
    else
    {
        float p = (fHue - 2.0/3.0)*3.0;
        vRgb.r = p;
        vRgb.g = 0.0;
        vRgb.b = 1.0 - p;
    }
    return vRgb;
}

/**
 * @param x: between 0..1
 * @param y: between 0..1
 * @param t: time in seconds
 * @return A value between 0..1
 */
float plasma1 (in float x, in float y, in float t)
{
    return 0.5 + 0.25*(sin (x*23.0*sin(M_PI*y + t)*sin (t*1.1)) 
                     + cos (y*23.0*cos(M_PI*x - t)*sin (t*3.1)));
}

/**
 * @param x: between 0..1
 * @param y: between 0..1
 * @param t: time in seconds
 * @return A value between 0..1
 */
float plasma2 (in float x, in float y, in float t)
{
    float a = -0.5 + 1.0*(sin(x*5.0)*(sin(4.0*t) + (y - 0.5)*2.0));
    float b = -0.5 + 1.0*(sin(y*5.0)*(cos(4.2*t) + (x - 0.5)*2.0));
    float c = 1.0 + 0.5*sin(t);
	return clamp (a + b + c, 0.0, 1.0);
}

/**
 * @param x: between 0..1
 * @param y: between 0..1
 * @param t: time in seconds
 * @return A value between 0..1
 */
float plasma3 (in float x, in float y, in float t)
{
    float a = sin(M_PI*x) + sin(M_PI*y) + sin(t/2.0);
    float b = sin(M_PI*x) * sin(M_PI*y) + sin(t/3.0);
	return smoothstep (0.0, 1.0, 0.3*(a + b));
}

/**
 * @param a, b, c: any value
 * @param m: between 0..1
 */
float mix3 (in float a, in float b, in float c, in float m)
{
    if (m <= 0.5)
    {
        return mix (a, b, m*2.0);
    }
    else
    {
        return mix (b, c, (m - 0.5)*2.0);
    }
}

void main(void)
{
	vec2 vRelCoord = gl_FragCoord.xy / iResolution.xy;
    float p1 = plasma1 (vRelCoord.x, vRelCoord.y, iGlobalTime);
    float p2 = plasma2 (vRelCoord.x, vRelCoord.y, iGlobalTime);
    float p3 = plasma3 (vRelCoord.x, vRelCoord.y, iGlobalTime);
    float fHue = mix3 (p1, p2, p3, 0.5 + 0.5*sin (iGlobalTime));
    vec3 vC1 = palette (fHue);
    
	gl_FragColor = vec4(vC1, 1.0);
}
